#!/bin/bash
datasets = ('caltech101', 'dtd', 'eurosat', 'fgvc', 'food101', 'oxford_flowers', 'oxford_pets',
                          'stanford_cars', 'sun397', 'ucf101')

log_file= #

for name in "${datasets[@]}"; do
  echo "Processing datset: $name" | tee -a $log_file

  CUDA_VISIBLE_DEVICES=5 python main_tta.py \
    --config configs/domain/${name}.yaml \
    --datasets ${name} \
    --backbone ViT-B/16 \
      --infer_type COS \
    | tee -a $log_file
done